#1. Load Required Packages
required_packages <- c("readxl","PMCMRplus","dplyr")
for (package in required_packages) {
  if (!requireNamespace(package, quietly = TRUE)) {
    install.packages(package)
  }
  library(package, character.only = TRUE)
}
#Description: This section ensures the required packages (readxl, PMCMRplus) are installed and loaded.


#2. Import Data Frame
if (!exists("df")) {
  file_path <- "~/COHORT_Prediction_of_CIP.xlsx"
  df <- read_excel(file_path, sheet = "cohort", na = "#N/A")
}
#Description: This section imports data from an Excel file if the data frame df does not already exist.


#3. Filter Data
df_filtered <- df[, c("pet_distance_ici","pet_impossible_spheres_placement","pet_glucose","pet_dose", "pet_acquisition")]

df_filtered_distance <- subset(df_filtered, pet_distance_ici <= 365 | is.na(pet_distance_ici))
df_filtered_distance <- subset(df_filtered_distance, pet_distance_ici >= -1)
df_filtered <- subset(df_filtered_distance, pet_impossible_spheres_placement == 0)
suppressWarnings(df_filtered[] <- lapply(df_filtered, as.numeric))
#Description: This section filters the data to include only records where distance between PET/CT and immunotherapy is between -1 and 365 days.

print(paste("...showed a median blood glucose level of", median(df_filtered$pet_glucose, na.rm = TRUE),"mg/dL (range", min(df_filtered$pet_glucose, na.rm = TRUE),"-", max(df_filtered$pet_glucose, na.rm = TRUE),"mg/dL)."))
print(paste("A median activity of", median(df_filtered$pet_dose, na.rm = TRUE),"MBq (range", min(df_filtered$pet_dose, na.rm = TRUE),"-", max(df_filtered$pet_dose, na.rm = TRUE),"MBq) 18F-PSMA-1007 was injected..."))

median_value <- median(as.numeric(df_filtered$pet_acquisition), na.rm = TRUE)
first_quartile <- quantile(as.numeric(df_filtered$pet_acquisition), na.rm = TRUE, 0.25)
third_quartile <- quantile(as.numeric(df_filtered$pet_acquisition), na.rm = TRUE, 0.75)
print(paste("PET acquisition was started at a median of", median_value,"min after tracer injection in median (1QU = ", first_quartile, " min; 3QU = ", third_quartile," min)"))

